﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading;
using System.Windows;
using Windows.Devices.Bluetooth;
using Windows.Devices.Bluetooth.Advertisement;

public class Define
{
    public const int OK_Num = 3;
    public const string ERROR_MSG = "error message";
}

//special thanks
//https://blog.okazuki.jp/entry/2016/07/19/221226

namespace WpfBleSampleApp
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        private BluetoothLEAdvertisementWatcher watcher;

        //private Dictionary<string, BluetoothLEDevice> devices = new Dictionary<string, BluetoothLEDevice>();
        private Dictionary<ulong, BluetoothLEDevice> devices = new Dictionary<ulong, BluetoothLEDevice>();

        private Mutex mutex = new Mutex();

    /*DeviceId*/
        /*private string[] okList =
        {
            "BluetoothLE#BluetoothLE98:5f:d3:d1:35:3f-74:99:95:70:e8:29",
            "BluetoothLE#BluetoothLE98:5f:d3:d1:35:3f-4e:03:3e:8f:50:96",
            "BluetoothLE#BluetoothLE98:5f:d3:d1:35:3f-43:2d:3f:b7:45:02",
            "",
            "",
             
        };*/

            /*BDアドレス*/
        private ulong[] okList =
        {
            /*82423332791826, //Bluetooth 4a:f6:ad:78:e6:12
            108555962440447,    //Bluetooth 62:bb:27:94:5a:ff
            117605944835917,
            76312922084733, //Bluetooth 45:67:fc:9c:d5:7d 自分の何か
            139673612859991,　// orutasu 12/19
            95952497671738, // orutasu 12/19
            104072803926013,    // orutasu 12/19
            112717208922713, //12/20 lab
            */

            //12/23 自宅
            72542603779210 ,//Bluetooth 41:fa:24:21:1c:8a, 
            119668175063121 ,//Bluetooth 6c:d6:6b:10:c8:51, 
            139563132157043,//Bluetooth 7e:ee:92:ea:7c:73,

            //1/8 lab
            140285132663853 ,//Bluetooth 7f:96:ad:7f:ec:2d, 
            83936478851746,//Bluetooth 4c:56:fc:01:72:a2,
        };
        /*private string[] okList =
       {
          Bluetooth 45:67:fc:9c:d5:7d, 76312922084733
          Bluetooth 62:bb:27:94:5a:ff, 108555962440447
          Bluetooth 59:d7:f7:2e:b4:b0, 98784099873968

            Bluetooth 45:67:fc:9c:d5:7d, 76312922084733
            Bluetooth 4a:f6:ad:78:e6:12, 82423332791826

            Bluetooth 45:fb:92:65:f1:77, 76946795262327
            Bluetooth 43:b4:22:bc:0b:c5, 74440955923397
            Bluetooth 45:67:fc:9c:d5:7d, 76312922084733
            Bluetooth 45:da:1d:36:ba:a5, 76803095313061

            Bluetooth 6f:2b:60:01:42:b7, 122232084972215
Bluetooth 78:dc:79:ad:81:08, 132888329552136
Bluetooth 48:64:11:76:c7:0d, 79594626926349
Bluetooth 72:b0:e5:06:05:76, 126104082187638
Bluetooth 5e:a7:56:82:3f:fd, 104072803926013
Bluetooth 5e:dc:1f:04:ac:04, 104299506215940
Bluetooth 5d:cb:9f:e8:a2:f1, 103129142567665

            Bluetooth 70:19:e9:5c:d2:55, 123256591667797 ,
Bluetooth 66:84:05:32:aa:59, 112717208922713 ,
Bluetooth 5f:85:83:41:60:a7, 105027037388967 ,

       };*/

        public MainWindow()
        {
            InitializeComponent();
            this.watcher = new BluetoothLEAdvertisementWatcher();

            //OK_List の表示
            this.TextBlockokList.Text += $"\n";
            foreach (var ok in okList)
                {
                this.TextBlockokList.Text += $"{ok}\n";
            }
            this.TextBlockokList.Text += $"--------------------------------\n";

            // CompanyIDとかDataでフィルタリングしたいとき
            //var md = new BluetoothLEManufacturerData();
            //// company id 0xFFFF (多分これ https://www.bluetooth.com/specifications/assigned-numbers/company-Identifiers)
            //md.CompanyId = 0xFFFF; 

            //// data 0x1234
            //var w = new DataWriter();
            //w.WriteUInt16(0x1234);
            //md.Data = w.DetachBuffer();
            //this.watcher.AdvertisementFilter.Advertisement.ManufacturerData.Add(md);


            // ↓https://docs.microsoft.com/ja-jp/windows/uwp/devices-sensors/ble-beacon
            // rssi >= -60のとき受信開始するっぽい
            this.watcher.SignalStrengthFilter.InRangeThresholdInDBm = -60; // >=-60dBm
            // rssi <= -65が2秒続いたら受信終わるっぽい
            this.watcher.SignalStrengthFilter.OutOfRangeThresholdInDBm = -65; // <=-65dBm
            this.watcher.SignalStrengthFilter.OutOfRangeTimeout = TimeSpan.FromMilliseconds(3000);// 3000ミリ秒以上遠ざかっていると受信終了
            this.watcher.Received += this.Watcher_Received;
        }

        private async void Watcher_Received(BluetoothLEAdvertisementWatcher sender, BluetoothLEAdvertisementReceivedEventArgs args)
        {
            /*
            await this.Dispatcher.InvokeAsync(() =>
            {
                var md = args.Advertisement.ManufacturerData.FirstOrDefault();
                if (md != null)
                {
                    // ManufactureDataをもとにCompanyIDとったりできる
                }
                var uuids = String.Join(",", args.Advertisement.ServiceUuids.Select(uuid => uuid.ToString()));
                this.TextBlockRSSI.Text = $"{args.Timestamp:HH\\:mm\\:ss}, RSSI: {args.RawSignalStrengthInDBm}, Address: {args.BluetoothAddress.ToString("X")}, Type: {args.AdvertisementType} , {args.Advertisement.ServiceUuids.Count}{uuids}";
            });
            */

            var task = BluetoothLEDevice.FromBluetoothAddressAsync(args.BluetoothAddress);
            //↑Adパケットをキャプチャするというタスク

            task.Completed = delegate
            {
                switch (task.Status)
                {
                    case Windows.Foundation.AsyncStatus.Completed://無事完了すれば
                        var device = task.GetResults();
                        if (device == null) return;
                        Debug.WriteLine($"device found:{device.Name},{device.BluetoothAddress}");// ここでKeyを決める

                        Debug.WriteLine($"device found:{device.Name},{device.DeviceId},{device.BluetoothAddress}");// ここでKeyを決める


                        if (device.WasSecureConnectionUsedForPairing) { //接続したことがあればSecure
                            Debug.WriteLine("####Secure####");
                        }

                        mutex.WaitOne();
                        devices[device.BluetoothAddress] = device;//DeviceId　と　device を結び付けている
                        //KeyにBDアドレスを選択

                        //RSSIが小さければ削除するコード（必要か？）

                        Debug.WriteLine("===========begin");
                        foreach (var x in devices)
                        {
                            var dev = x.Value;
                            var id = x.Key; // == dev.BluetoothAddress

                            Debug.WriteLine($"{dev.Name}, {id} ,");// Name,BluetoothAddress
                        }
                        Debug.WriteLine("===========end");
                        mutex.ReleaseMutex();

                        this.Dispatcher.InvokeAsync(() =>
                        {
                            mutex.WaitOne();
                            this.TextBlockRSSI.Text = "";
                            foreach (var x in devices)
                            {
                                var dev = x.Value;
                                var id = x.Key; // == dev.DeviceId

                                this.TextBlockRSSI.Text += $"{dev.Name}, {id}\n";
                            }

                            // OKリストの中身と何個一致しているか
                            //var count = okList.Count((okId) => devices.ContainsKey(okId));

                            var count = okList.Count((okId) => devices.ContainsKey(okId));

                            this.TextBlockRSSI.Text += $"ok count: {count}\n";

                            if (count >= Define.OK_Num) {
                                this.TextBlockRSSI.Text += $"You are You!\n";
                            }

                            mutex.ReleaseMutex();
                        });
                        break;

                    case Windows.Foundation.AsyncStatus.Started:
                        Debug.WriteLine($"started: ");
                        break;

                    default:
                        Debug.WriteLine($"failed: {task.Status} {task.ErrorCode}");
                        break;
                }
            };
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            this.watcher.Stop();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            this.watcher.Start();
        }
    }
}